# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 2
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR2_strategy.txt
# LLM Suggested Fallback: D

def honeyed_serpent(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history)
    last_opp_move = opp_history[-1]
    
    if "always cooperate" in opponent_program_code.lower():
        if current_round >= 3:
            return "D"
        else:
            return "C"
    
    if "always defect" in opponent_program_code.lower():
        return "D"
    
    if current_round == 9:
        return "D"
    
    if last_opp_move == "C":
        return "C" if random.random() < 0.9 else "D"
    else:
        return "D" if random.random() < 0.8 else "C"